/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class InfusionRecipe
implements IInfusionRecipe {
    public static final int RECIPE_SIZE = 9;
    private final Ingredient input;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack result;
    private final boolean transferComponents;
    private BiFunction<Integer, ItemStack, ItemStack> transformer;

    public InfusionRecipe(Ingredient input, NonNullList<Ingredient> inputs, ItemStack result, boolean transferComponents) {
        this.input = input;
        this.inputs = inputs;
        this.result = result;
        this.transferComponents = transferComponents;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount() - 1) {
            return false;
        }
        ItemStack input = inventory.getItem(0);
        if (!this.input.test(input)) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 1; i < inventory.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        ItemStack stack = inventory.getItem(0);
        ItemStack result = this.result.copy();
        if (this.transferComponents) {
            result.applyComponents(stack.getComponentsPatch());
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.INFUSION.get();
    }

    public RecipeType<? extends IInfusionRecipe> getType() {
        return (RecipeType)ModRecipeTypes.INFUSION.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!item.hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)item.getCraftingRemainingItem());
        }
        if (this.transformer != null) {
            boolean[] used = new boolean[remaining.size()];
            NonNullList inputs = NonNullList.create();
            inputs.add((Object)this.input);
            inputs.addAll(this.inputs);
            block1: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inventory.getItem(i);
                for (int j = 0; j < inputs.size(); ++j) {
                    Ingredient input = (Ingredient)inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformer.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block1;
                }
            }
        }
        return remaining;
    }

    @Override
    public Ingredient getAltarIngredient() {
        return this.input;
    }

    public void setTransformer(BiFunction<Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public static final MapCodec<InfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(recipe -> recipe.input), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            int max = 8;
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for infusion recipe");
            }
            return ingredients.length > max ? DataResult.error(() -> "Too many ingredients for infusion recipe. The maximum is: %s".formatted(max)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.inputs), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("transfer_components", (Object)false).forGetter(recipe -> recipe.transferComponents)).apply((Applicative)builder, InfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<InfusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static InfusionRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean transferComponents = buffer.readBoolean();
            return new InfusionRecipe(input, (NonNullList<Ingredient>)inputs, result, transferComponents);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, InfusionRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.transferComponents);
        }
    }
}

